<?php

//Load composer's autoloader
require  F_ROOT.'vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;


class Mail
{
    public static function sendMail($fromEmail = '', $fromName = '', $toEmail = '', $replyToEmail = '', $subject = '', $body = '', $attachments = array())
    {
        
        $mail = new PHPMailer;

        $mail->isSMTP();
        $mail->Host        = SMTP_HOST;
        $mail->SMTPAuth    = true;
        $mail->Username    = SMTP_USERNAME;
        $mail->Password    = SMTP_PASSWORD;
        $mail->SMTPSecure  = "tls";
        $mail->Port        = SMTP_PORT;
        $mail->SMTPAutoTLS = false;
        //$mail->SMTPDebug = 2;

        $fromEmail = $fromEmail ? $fromEmail : SMTP_USERNAME;
        $fromName  = $fromName ? $fromName : "Chico Dental Care";
        $mail->setFrom($fromEmail, $fromName);
        $mail->addAddress($toEmail);

        if (!empty($attachments)) {
            foreach ($attachments as $attachment) {
                $mail->addAttachment($attachment);
            }
        }
        $mail->SMTPOptions = array(
            'ssl' => array(
                'verify_peer'       => false,
                'verify_peer_name'  => false,
                'allow_self_signed' => true
            )
        );
        if ($replyToEmail) {
            $mail->addReplyTo($replyToEmail);
        }

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $body;

        if (!$mail->send()) {
            $successful = self::sendPHPMail($fromEmail, $fromName, $toEmail, $replyToEmail, $subject, $body, $attachments);
            return ['success' => $successful];
        } else {
            
            return ['success' => true];
        }
    }

    public static function sendPHPMail($fromEmail = '', $fromName = '', $toEmail = '', $replyToEmail = '', $subject = '', $body = '', $attachments = array())
    {

        $fromEmail    = $fromEmail ? $fromEmail : SMTP_USERNAME;
        $fromName     = $fromName ? $fromName : "Chico Dental Care";
        $replyToEmail = $replyToEmail ? $replyToEmail : SMTP_USERNAME;

        // carriage return type (RFC)
        $eol = "\r\n";
        // a random hash will be necessary to send mixed content
        $semi_rand = md5(time());
        // boundary
        $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
        // headers
        $headers = 'From: ' . $fromName . ' <' . $fromEmail . '>' . $eol;
        $headers .= 'Reply-to: <' . $replyToEmail . '>' . $eol;
        // headers for attachment
        $headers .= "MIME-Version: 1.0" . $eol;
        $headers .= "Content-Type: multipart/mixed; boundary=\"" . $mime_boundary . "\"" . $eol;

        // multipart boundary
        $message = "This is a multi-part message in MIME format.$eol" . "--{$mime_boundary}$eol" . "Content-Type: text/html; charset=\"UTF-8\"$eol" . $body . $eol;
        $message .= "--{$mime_boundary}$eol";

        // preparing attachments
        foreach ($attachments as $attachment) {
            $fname = basename($attachment);
            $file  = fopen($attachment, "rb");
            $data  = fread($file, filesize($attachment));
            fclose($file);
            $data = chunk_split(base64_encode($data));
            $message .= "Content-Type: {\"application/octet-stream\"};$eol" . " name=\"$attachment\"$eol" .
                        "Content-Disposition: attachment;$eol" . " filename=\"$fname\"$eol" .
                        "Content-Transfer-Encoding: base64$eol" . $data . "$eol";
            $message .= "--{$mime_boundary}$eol";
        }

        if (mail($toEmail, $subject, $message, $headers)) {
            return true;
        } else {
            return false;
        }
    }

}